﻿using NVCC.Models;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web.ModelBinding;

namespace NVCC.WebUI.Models
{
    public class LoginViewModel
    {
        [Display(Name = "Access Code")]
        public string UserName { get; set; }

        [DataType(DataType.Password)]
        [Display(Name = "Verify Code")]
        public string Password { get; set; }

        [Display(Name = "Station")]
        public short sta3n { get; set; }

        [BindNever]
        public IEnumerable<UserFacility> AvailableFacilities { get; set; }

        public string ReturnAction { get; set; }
        public string ReturnController { get; set; }
    }
}